// BaseParaSet.cpp : implementation file
//

#include "stdafx.h"
#include "DEMO.h"

#include "BaseParaSet.h"
#include "CtrlCard.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CCtrlCard g_CtrlCard;
/////////////////////////////////////////////////////////////////////////////
// CBaseParaSet dialog


CBaseParaSet::CBaseParaSet(CWnd* pParent /*=NULL*/)
	: CDialog(CBaseParaSet::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBaseParaSet)
	m_nEffectLogic_w = -1;
	m_nEffectLogic_x = -1;
	m_nEffectLogic_y = -1;
	m_nEffectLogic_z = -1;
	m_nPulseMode_w = -1;
	m_nPulseMode_x = -1;
	m_nPulseMode_y = -1;
	m_nPulseMode_z = -1;
	m_nStop0Mode_w = -1;
	m_nStop0Mode_x = -1;
	m_nStop0Mode_y = -1;
	m_nStop0Mode_z = -1;
	m_nStop1Mode_w = -1;
	m_nStop1Mode_x = -1;
	m_nStop1Mode_y = -1;
	m_nStop1Mode_z = -1;	
	m_nStop2Mode_w = -1;
	m_nStop2Mode_x = -1;
	m_nStop2Mode_y = -1;
	m_nStop2Mode_z = -1;
	m_nCompPnum = 1000;
	m_nCompNnum = 1000;
	m_nSoftLimitMode3 = -1;
	m_nSoftLimitMode1 = -1;
	m_nSoftLimitMode2 = -1;
	m_nAlarmMode_w = -1;
	m_nAlarmMode_x = -1;
	m_nAlarmMode_y = -1;
	m_nAlarmMode_z = -1;
	m_nInposMode_w = -1;
	m_nInposMode_x = -1;
	m_nInposMode_y = -1;
	m_nInposMode_z = -1;
	m_nCircleMode1 = -1;
	m_nCircle_x = -1;
	m_nCircle_y = -1;
	m_nCircle_w = -1;
	m_nCircle_z = -1;
	m_nLimitMode_x = -1;
	m_nLimitMode_y = -1;
	m_nLimitMode_z = -1;
	m_nLimitMode_w = -1;
	m_nStop2Mode_v = -1;
	m_nStop2Mode_u = -1;
	m_nAlarmMode_v = -1;
	m_nAlarmMode_u = -1;
	m_nCircle_v = -1;
	m_nCircle_u = -1;
	m_nEffectLogic_u = -1;
	m_nEffectLogic_v = -1;
	m_nInposMode_v = -1;
	m_nInposMode_u = -1;
	m_nLimitMode_v = -1;
	m_nLimitMode_u = -1;
	m_nStop0Mode_v = -1;
	m_nStop0Mode_u = -1;
	m_nStop1Mode_v = -1;
	m_nStop1Mode_u = -1;
	m_nPulseMode_v = -1;
	m_nPulseMode_u = -1;
	//}}AFX_DATA_INIT
}


void CBaseParaSet::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBaseParaSet)
	DDX_Radio(pDX, IDC_EFFECTLOGIC_W, m_nEffectLogic_w);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_X, m_nEffectLogic_x);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_Y, m_nEffectLogic_y);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_Z, m_nEffectLogic_z);
	DDX_Radio(pDX, IDC_PULSEMODE_W, m_nPulseMode_w);
	DDX_Radio(pDX, IDC_PULSEMODE_X, m_nPulseMode_x);
	DDX_Radio(pDX, IDC_PULSEMODE_Y, m_nPulseMode_y);
	DDX_Radio(pDX, IDC_PULSEMODE_Z, m_nPulseMode_z);
	DDX_Radio(pDX, IDC_STOP0MODE_W, m_nStop0Mode_w);
	DDX_Radio(pDX, IDC_STOP0MODE_X, m_nStop0Mode_x);
	DDX_Radio(pDX, IDC_STOP0MODE_Y, m_nStop0Mode_y);
	DDX_Radio(pDX, IDC_STOP0MODE_Z, m_nStop0Mode_z);
	DDX_Radio(pDX, IDC_STOP1MODE_W, m_nStop1Mode_w);
	DDX_Radio(pDX, IDC_STOP1MODE_X, m_nStop1Mode_x);
	DDX_Radio(pDX, IDC_STOP1MODE_Y, m_nStop1Mode_y);
	DDX_Radio(pDX, IDC_STOP1MODE_Z, m_nStop1Mode_z);
	DDX_Radio(pDX, IDC_STOP2MODE_W, m_nStop2Mode_w);
	DDX_Radio(pDX, IDC_STOP2MODE_X, m_nStop2Mode_x);
	DDX_Radio(pDX, IDC_STOP2MODE_Y, m_nStop2Mode_y);
	DDX_Radio(pDX, IDC_STOP2MODE_Z, m_nStop2Mode_z);
	DDX_Text(pDX, IDC_EDIT1_PCOMP, m_nCompPnum);
	DDX_Text(pDX, IDC_EDIT2_NCOMP, m_nCompNnum);
	DDX_Radio(pDX, IDC_SOFTLIM_MODE0, m_nSoftLimitMode3);
	DDX_Radio(pDX, IDC_PCOMP_NULL, m_nSoftLimitMode1);
	DDX_Radio(pDX, IDC_NCOMP_NULL, m_nSoftLimitMode2);
	DDX_Radio(pDX, IDC_ALARMMODE_W, m_nAlarmMode_w);
	DDX_Radio(pDX, IDC_ALARMMODE_X, m_nAlarmMode_x);
	DDX_Radio(pDX, IDC_ALARMMODE_Y, m_nAlarmMode_y);
	DDX_Radio(pDX, IDC_ALARMMODE_Z, m_nAlarmMode_z);
	DDX_Radio(pDX, IDC_INPOSMODE_W, m_nInposMode_w);
	DDX_Radio(pDX, IDC_INPOSMODE_X, m_nInposMode_x);
	DDX_Radio(pDX, IDC_INPOSMODE_Y, m_nInposMode_y);
	DDX_Radio(pDX, IDC_INPOSMODE_Z, m_nInposMode_z);
	DDX_Radio(pDX, IDC_CIRCLE_X, m_nCircle_x);
	DDX_Radio(pDX, IDC_CIRCLE_Y, m_nCircle_y);
	DDX_Radio(pDX, IDC_CIRCLE_W, m_nCircle_w);
	DDX_Radio(pDX, IDC_CIRCLE_Z, m_nCircle_z);
	DDX_Radio(pDX, IDC_LIMITMODE_X, m_nLimitMode_x);
	DDX_Radio(pDX, IDC_LIMITMODE_Y, m_nLimitMode_y);
	DDX_Radio(pDX, IDC_LIMITMODE_Z, m_nLimitMode_z);
	DDX_Radio(pDX, IDC_LIMITMODE_W, m_nLimitMode_w);
	DDX_Radio(pDX, IDC_STOP2MODE_V, m_nStop2Mode_v);
	DDX_Radio(pDX, IDC_STOP2MODE_U, m_nStop2Mode_u);
	DDX_Radio(pDX, IDC_ALARMMODE_V, m_nAlarmMode_v);
	DDX_Radio(pDX, IDC_ALARMMODE_U, m_nAlarmMode_u);
	DDX_Radio(pDX, IDC_CIRCLE_V, m_nCircle_v);
	DDX_Radio(pDX, IDC_CIRCLE_U, m_nCircle_u);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_U, m_nEffectLogic_u);
	DDX_Radio(pDX, IDC_EFFECTLOGIC_V, m_nEffectLogic_v);
	DDX_Radio(pDX, IDC_INPOSMODE_V, m_nInposMode_v);
	DDX_Radio(pDX, IDC_INPOSMODE_U, m_nInposMode_u);
	DDX_Radio(pDX, IDC_LIMITMODE_V, m_nLimitMode_v);
	DDX_Radio(pDX, IDC_LIMITMODE_U, m_nLimitMode_u);
	DDX_Radio(pDX, IDC_STOP0MODE_V, m_nStop0Mode_v);
	DDX_Radio(pDX, IDC_STOP0MODE_U, m_nStop0Mode_u);
	DDX_Radio(pDX, IDC_STOP1MODE_V, m_nStop1Mode_v);
	DDX_Radio(pDX, IDC_STOP1MODE_U, m_nStop1Mode_u);
	DDX_Radio(pDX, IDC_PULSEMODE_V, m_nPulseMode_v);
	DDX_Radio(pDX, IDC_PULSEMODE_U, m_nPulseMode_u);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBaseParaSet, CDialog)
	//{{AFX_MSG_MAP(CBaseParaSet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBaseParaSet message handlers

BOOL CBaseParaSet::OnInitDialog() 
{
	CDialog::OnInitDialog();

	//************set base para*************//

	//**********set pulse type*******************//
	//  0-pulse + pulse   1pulse + direction   //
	//   default :  pulse + direction            //
	//*******************************************//
    m_nPulseMode_x  = 1;
	m_nPulseMode_y  = 1;
	m_nPulseMode_z  = 1;
	m_nPulseMode_w  = 1;
    m_nPulseMode_u  = 1;
	m_nPulseMode_v  = 1;

	//*************Set LMT type**************//
	//  0-effective   1ineffective        //
	//        default :  effective           //
	//**************************************//
	m_nLimitMode_x = 0;
	m_nLimitMode_y = 0;
	m_nLimitMode_z = 0;
	m_nLimitMode_w = 0;
    m_nLimitMode_u = 0;
	m_nLimitMode_v = 0;

	//***********Set stop0 type***********//
	//     0-ineffective   1effective    //
	//      default :  infective          //
	//***********************************//
	m_nStop0Mode_x  = 0;
	m_nStop0Mode_y  = 0;
	m_nStop0Mode_z  = 0;
	m_nStop0Mode_w  = 0;
	m_nStop0Mode_u  = 0;
	m_nStop0Mode_v  = 0;

	//***********Set stop1 type***********//
	//     0-ineffective   1effective    //
	//      default :  infective          //
	//***********************************//
	m_nStop1Mode_x  = 0;
	m_nStop1Mode_y  = 0;
	m_nStop1Mode_z  = 0;
	m_nStop1Mode_w  = 0;
	m_nStop1Mode_u  = 0;
	m_nStop1Mode_v  = 0;

	//***********Set stop2 type***********//
	//     0-ineffective   1effective    //
	//      default :  infective          //
	//***********************************//
	m_nStop2Mode_x = 0;
	m_nStop2Mode_y = 0;
	m_nStop2Mode_z = 0;
	m_nStop2Mode_w = 0;
	m_nStop2Mode_u = 0;
	m_nStop2Mode_v = 0;

	//***********COMP+ ,set register*********//
	//        0-ineffective   1effective  //
	//        default :  infective         //
	//***********************************//
	m_nSoftLimitMode1=0;

	//***********COMP- ,set register*********//
	//        0-ineffective   1effective  //
	//        default :  infective         //
	//***********************************//
	m_nSoftLimitMode2=0;
	
	//*********set position register*********//
	//        0:logic position counter	    //
	//        1:real position counter      //
	//        default:logic position counter	 //
	//***********************************//
	m_nSoftLimitMode3=0;
	
	//**********set servo position signal mode*********//
	//value		0ineffective	 1effective   //
	//logic		0low level effective  1high level effective //
	//return	0right			1error  //        
	//***********************************//
	m_nInposMode_x=0;
	m_nInposMode_y=0;
	m_nInposMode_z=0;
	m_nInposMode_w=0;
	m_nInposMode_u=0;
	m_nInposMode_v=0;

	//********set alarm signal for servo mode*********//
	//value		0ineffective	 1effective     //
	//logic		0low level effective  1high level effective//
	//return	0right			1error     //        
	//***********************************//
	m_nAlarmMode_x=0;
	m_nAlarmMode_y=0;
	m_nAlarmMode_z=0;
	m_nAlarmMode_w=0;
	m_nAlarmMode_u=0;
	m_nAlarmMode_v=0;

	
	//************set Active level************//
	// for level of LMT+/-STOP0STOP1STOP2//
	//logic:  0:low level effective  1:high level effective //
	//default: low level effective    //
	//************************************//
	m_nEffectLogic_x = 0;
	m_nEffectLogic_y = 0;
	m_nEffectLogic_z = 0;
	m_nEffectLogic_w = 0;
	m_nEffectLogic_u = 0;
	m_nEffectLogic_v = 0;
	
	//***********set position counter variabe ring********//
	//     0:ineffective     1:effective      //
	//default: ineffective              //
	//***********************************//
	m_nCircle_x = 0;
	m_nCircle_y = 0;
    m_nCircle_z = 0;
	m_nCircle_w = 0;	
	m_nCircle_u = 0;
	m_nCircle_v = 0;
		

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CBaseParaSet::OnOK() 
{
	UpdateData();
	
	int  pulsemode[]={m_nPulseMode_x, m_nPulseMode_y, m_nPulseMode_z, m_nPulseMode_w,m_nPulseMode_u, m_nPulseMode_v};   //pulse output type     
	
	int  limitmode[]={m_nLimitMode_x,m_nLimitMode_y,m_nLimitMode_z,m_nLimitMode_w,m_nLimitMode_u,m_nLimitMode_v};   //LMT+/- type
	
	int inposmode[]={m_nInposMode_x,  m_nInposMode_y,m_nInposMode_z , m_nInposMode_w,m_nInposMode_u , m_nInposMode_v};//servo position single mode
	
	int alarmmode[]={m_nAlarmMode_x, m_nAlarmMode_y, m_nAlarmMode_z, m_nAlarmMode_w, m_nAlarmMode_u, m_nAlarmMode_v};//servo alarm single mode
	
	int  stop0mode[]={m_nStop0Mode_x, m_nStop0Mode_y, m_nStop0Mode_z,m_nStop0Mode_w, m_nStop0Mode_u,m_nStop0Mode_v};         //stop0 type
	
	int  stop1mode[]={m_nStop1Mode_x, m_nStop1Mode_y, m_nStop1Mode_z,m_nStop1Mode_w, m_nStop1Mode_u,m_nStop1Mode_v};         //stop1 type
	
	int  stop2mode[]={m_nStop2Mode_x, m_nStop2Mode_y, m_nStop2Mode_z,m_nStop2Mode_w, m_nStop2Mode_u,m_nStop2Mode_v};         //stop2 type
	
	int  effectlogic[]={m_nEffectLogic_x, m_nEffectLogic_y, m_nEffectLogic_z, m_nEffectLogic_w, m_nEffectLogic_u, m_nEffectLogic_v};  //level
	
	int  circlemode[]={m_nCircle_x, m_nCircle_y, m_nCircle_z, m_nCircle_w, m_nCircle_u, m_nCircle_v };//circle alterable mode
	
	for(int i=1; i<MAXAXIS+1; i++)
	{
		//set pulse type
		g_CtrlCard.Setup_PulseMode(i, pulsemode[i-1]);             
		
		//set LMT type
		g_CtrlCard.Setup_LimitMode(i, limitmode[i-1], effectlogic[i-1]);
		
		//set stop0 type
		g_CtrlCard.Setup_Stop0Mode(i, stop0mode[i-1], effectlogic[i-1]);
		
		//set stop1 type
		g_CtrlCard.Setup_Stop1Mode(i, stop1mode[i-1], effectlogic[i-1]);
		
		//set stop2 type
		g_CtrlCard.Setup_Stop2Mode(i, stop2mode[i-1], effectlogic[i-1]);
		
		//Set of COMP+ register as software limit
		g_CtrlCard.Setsoft_LimitMode1(i,m_nSoftLimitMode1);
		
		//Set of COMP- register as software limit
		g_CtrlCard.Setsoft_LimitMode2(i,m_nSoftLimitMode2);
		
		//Setup of comparative object for COMP+/- register
		g_CtrlCard.Setsoft_LimitMode3(i,m_nSoftLimitMode3);
		
       //set comp+ register
		g_CtrlCard.Setup_Comp1(i,m_nCompPnum);
		
        //set comp- register
		g_CtrlCard.Setup_Comp2(i,m_nCompNnum);
		
		//set servo position single
        g_CtrlCard.Inpos_Mode(i, inposmode[i-1], effectlogic[i-1]);
		
		//set servo alarm single
        g_CtrlCard.Setup_AlarmMode(i, alarmmode[i-1], effectlogic[i-1]);
        
		//position counter variable ring
		g_CtrlCard.SetCircle_Mode(i,circlemode[i-1]);
		
		//Setup of signal wave filtering function
        g_CtrlCard.Setup_InputFilter(i,1,0);
		
        //Setup of wave filter time constant of input signal
        g_CtrlCard.Setup_FilterTime(i,1);//value 1: Maximum noise scope deleted ,   Delay of input signal
		
	}
	
	CDialog::OnOK();
}
